/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.ws.api.uddi.WSUDDIRegistry;
import filenet.ws.utils.WSValidateServerCertificate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VWUDDIAuthenticationDialog
extends VWModalDialog
implements ActionListener,
DocumentListener {
    private WSUDDIRegistry m_uddiRegistry = null;
    private String m_username = null;
    private JTextField m_uddiRegistryName = null;
    private JTextField m_usernameTextField = null;
    private JLabel m_usernameLabel = null;
    private JPasswordField m_password = null;
    private JButton m_logonButton = null;
    private JButton m_cancel = null;
    private boolean m_bCancel = false;

    public VWUDDIAuthenticationDialog(Frame parent, String username, WSUDDIRegistry uddiRegistry) {
        super(parent);
        this.init(username, uddiRegistry);
    }

    public VWUDDIAuthenticationDialog(Dialog parent, String username, WSUDDIRegistry uddiRegistry) {
        super(parent);
        this.init(username, uddiRegistry);
    }

    public void addNotify() {
        super.addNotify();
        if (this.m_usernameTextField != null) {
            this.m_usernameTextField.requestFocus();
        } else if (this.m_password != null) {
            this.m_password.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_logonButton) {
            if (this.login()) {
                this.m_bCancel = false;
                this.setVisible(false);
            }
        } else if (source == this.m_usernameTextField || source == this.m_password) {
            JButton defaultButton = this.getRootPane().getDefaultButton();
            if (defaultButton != null) {
                defaultButton.doClick();
            }
        } else if (source == this.m_cancel) {
            this.m_bCancel = true;
            this.setVisible(false);
        }
    }

    public void insertUpdate(DocumentEvent event) {
        this.setLogonButtonState();
    }

    public void removeUpdate(DocumentEvent event) {
        this.setLogonButtonState();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    private void init(String username, WSUDDIRegistry uddiRegistry) {
        this.m_uddiRegistry = uddiRegistry;
        this.m_username = username;
        if (this.m_username != null && this.m_username.length() == 0) {
            this.m_username = null;
        }
        this.setupDialogLayout();
        this.setLogonButtonState();
    }

    private void setupDialogLayout() {
        GridBagConstraints c = new GridBagConstraints();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension("335,195");
        if (dim == null) {
            dim = new Dimension(300, 180);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_uddiRegistryLogin);
        VWAccessibilityHelper.setAccessibility(this, null, VWResource.s_uddiRegistryLogin, VWResource.s_uddiRegistryLogin);
        this.m_uddiRegistryName = new JTextField();
        this.m_uddiRegistryName.setEditable(false);
        this.m_uddiRegistryName.setBorder(null);
        if (this.m_uddiRegistry != null) {
            this.m_uddiRegistryName.setText(this.m_uddiRegistry.getName());
        }
        VWAccessibilityHelper.setAccessibility(this.m_uddiRegistryName, this, VWResource.s_uddiRegistryNameTextField, VWResource.s_uddiRegistryNameTextField);
        if (this.m_username == null) {
            this.m_usernameTextField = new JTextField();
            VWAccessibilityHelper.setAccessibility(this.m_usernameTextField, this, VWResource.s_userNameTextField, VWResource.s_userNameTextField);
        } else {
            this.m_usernameLabel = new JLabel(this.m_username);
            VWAccessibilityHelper.setAccessibility(this.m_usernameLabel, this, this.m_username, this.m_username);
        }
        this.m_password = new JPasswordField();
        VWAccessibilityHelper.setAccessibility(this.m_password, this, VWResource.s_passwordField, VWResource.s_passwordField);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 23;
        JLabel label = new JLabel(VWResource.s_label.toString(VWResource.s_uddiRegistry));
        mainPanel.add((Component)label, c);
        VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_uddiRegistry, VWResource.s_uddiRegistry);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 0);
        mainPanel.add((Component)this.m_uddiRegistryName, c);
        VWAccessibilityHelper.setLabelFor(label, this.m_uddiRegistryName);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.insets = new Insets(10, 0, 0, 0);
        label = new JLabel(VWResource.s_userName);
        mainPanel.add((Component)label, c);
        VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_userName, VWResource.s_userName);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 0);
        if (this.m_usernameTextField != null) {
            mainPanel.add((Component)this.m_usernameTextField, c);
            VWAccessibilityHelper.setLabelFor(label, this.m_usernameTextField);
        } else if (this.m_usernameLabel != null) {
            mainPanel.add((Component)this.m_usernameLabel, c);
            VWAccessibilityHelper.setLabelFor(label, this.m_usernameLabel);
        }
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        label = new JLabel(VWResource.s_password);
        mainPanel.add((Component)label, c);
        VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_password, VWResource.s_password);
        ++c.gridy;
        c.insets = new Insets(0, 10, 0, 0);
        mainPanel.add((Component)this.m_password, c);
        VWAccessibilityHelper.setLabelFor(label, this.m_password);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_logonButton = new JButton(VWResource.s_logon);
        this.m_cancel = new JButton(VWResource.s_cancel);
        panel.add(this.m_logonButton);
        panel.add(this.m_cancel);
        VWAccessibilityHelper.setAccessibility(this.m_logonButton, this, VWResource.s_logon, VWResource.s_logon);
        VWAccessibilityHelper.setAccessibility(this.m_cancel, this, VWResource.s_cancel, VWResource.s_cancel);
        ++c.gridy;
        mainPanel.add((Component)panel, c);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)mainPanel, "Center");
        if (this.m_usernameTextField != null) {
            this.m_usernameTextField.requestDefaultFocus();
            this.m_usernameTextField.getDocument().addDocumentListener(this);
            this.m_usernameTextField.addActionListener(this);
        }
        this.m_password.addActionListener(this);
        this.m_logonButton.addActionListener(this);
        this.m_cancel.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_logonButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean login() {
        boolean bl;
        block10: {
            Cursor currentCursor = null;
            try {
                currentCursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
                String username = null;
                String password = null;
                username = this.m_usernameTextField != null ? this.m_usernameTextField.getText() : this.m_username;
                if (username != null && username.length() == 0) {
                    username = null;
                }
                if (this.m_password != null) {
                    password = new String(this.m_password.getPassword());
                }
                if (this.m_uddiRegistry != null) {
                    if (username == null) {
                        password = null;
                    } else if (password == null) {
                        password = "";
                    }
                    WSValidateServerCertificate.useProcessTrustStore();
                    this.m_uddiRegistry.setUserInfo(username, password);
                    WSValidateServerCertificate.useDefaultTrustStore();
                }
                this.m_username = username;
                bl = true;
                Object var6_8 = null;
                if (currentCursor == null) break block10;
            }
            catch (Exception ex) {
                boolean bl2;
                block11: {
                    try {
                        String msg = new String(VWResource.s_failedToLoginToUddiRegistry.toString(this.m_uddiRegistry.getName()));
                        this.showMessage(this.getParent(), msg, VWResource.s_logon, 1, ex);
                        VWDebug.logException(ex);
                        bl2 = false;
                        Object var6_9 = null;
                        if (currentCursor == null) break block11;
                    }
                    catch (Throwable throwable) {
                        block12: {
                            Object var6_10 = null;
                            if (currentCursor == null) break block12;
                            this.setCursor(currentCursor);
                        }
                        throw throwable;
                    }
                    this.setCursor(currentCursor);
                }
                return bl2;
            }
            this.setCursor(currentCursor);
        }
        return bl;
    }

    public boolean isCanceled() {
        return this.m_bCancel;
    }

    public String getUsername() {
        return this.m_username;
    }

    private void setLogonButtonState() {
        if (this.m_logonButton == null) {
            return;
        }
        boolean bEnable = false;
        if (this.m_usernameTextField != null) {
            String tempString = this.m_usernameTextField.getText();
            if (tempString != null) {
                tempString.trim();
                if (tempString.length() > 0) {
                    bEnable = true;
                }
            }
        } else if (this.m_username != null) {
            bEnable = true;
        }
        if (this.m_logonButton.isEnabled() != bEnable) {
            this.m_logonButton.setEnabled(bEnable);
        }
    }

    private String showMessage(Container container, String msg, String title, int msgType, Exception ex) {
        if (ex != null) {
            msg = msg == null ? new String(ex.toString()) : msg + "\n" + ex.toString();
        }
        if (container instanceof Frame) {
            VWMessageDialog.showOptionDialog((Frame)container, msg, title, msgType);
        } else if (container instanceof JDialog) {
            VWMessageDialog.showOptionDialog((JDialog)container, msg, title, msgType);
        } else {
            JOptionPane.showMessageDialog(container, msg, title, msgType);
        }
        return msg;
    }
}

